% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvdenoising.R
\name{tvdenoising}
\alias{tvdenoising}
\title{Univariate total variation denoising}
\usage{
tvdenoising(y, lambda, weights = NULL)
}
\arguments{
\item{y}{Vector of observations to be denoised.}

\item{lambda}{Regularization parameter value. Must be >= 0.}

\item{weights}{Vector of observation weights. The default is \code{NULL}, which
corresponds to unity weights. If specified, this vector must have the same
length as \code{y}, and must have positive entries.}
}
\value{
Vector of denoised values.
}
\description{
Denoises a sequence of observations by solving the univariate total variation
denoising optimization problem at a given regularization level.
}
\details{
This function minimizes the univariate total variation denoising
(also called fused lasso) criterion squares criterion
\deqn{
  \frac{1}{2} \sum_{i=1}^n (y_i - \theta_i)^2 + 
    \lambda \sum_{i=1}^{n-1} |\theta_{i+1} - \theta_i|,
  }
over \eqn{\theta}. This is a special structured convex optimization problem
which can be solved in linear time (\eqn{O(n)} operations) using algorithms
based on dynamic programming (Viterbi) or taut string methods. The current
function implements a highly-efficient dynamic programming method developed
by Johnson (2013).
}
\examples{
y <- c(rep(0, 50), rep(3, 50)) + rnorm(100)
yhat <- tvdenoising(y, 5)
plot(y, pch = 16, col = "gray60")
lines(yhat, col = "firebrick", lwd = 2)
}
\references{
Johnson (2013), "A dynamic programming algorithm for the fused
lasso and L0-segmentation."
}
