% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abcxyz.R
\name{abcxyz}
\alias{abcxyz}
\title{ABC-XYZ visualisation}
\usage{
abcxyz(imp, frc, outplot = c(TRUE, FALSE), error = NULL, ...)
}
\arguments{
\item{imp}{an obkect of class \code{abc} that is the output of function \code{\link{abc}}.}

\item{frc}{an obkect of class \code{abc} that is the output of function \code{\link{xyz}}.}

\item{outplot}{if \code{TRUE}, then provide a visualisation of the analyses.}

\item{error}{vector of forecast errors for each series that will be distributed in each class, presented as an average.}

\item{...}{additional arguments passed to the plot.}
}
\value{
A list containing:
\itemize{
\item \code{class}: a matrix containing the number of time series in each class.
\item \code{error}: a matrix containing the averaged error for each class, if the argument \code{error} was used.
}
}
\description{
Jointly visualise ABC and XYZ analyses.
}
\examples{
x <- abs(matrix(cumsum(rnorm(5400,0,1)),36,150))
abcxyz(abc(x),xyz(x,type="cv"))

}
\references{
Ord K., Fildes R., Kourentzes N. (2017) \href{https://kourentzes.com/forecasting/2017/10/16/new-forecasting-book-principles-of-business-forecasting-2e/}{Principles of Business Forecasting, 2e}. \emph{Wessex Press Publishing Co.}, p.515-518.
}
\seealso{
\code{\link{abc}}, \code{\link{xyz}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{ts}
