% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.R
\name{ts.match}
\alias{ts.match}
\title{Correlation calculation based on rolling window with overlapping observations.}
\usage{
ts.match(x, y, cutoff = 1)
}
\arguments{
\item{x}{time series}

\item{y}{subsection of the time series to map}

\item{cutoff}{benchmark value for corr, default 1}
}
\value{
Pearson's correlation coefficient between \code{x} and \code{y}
}
\description{
Correlation calculation based on rolling window with overlapping observations.
}
\examples{
x <- rnorm(15)
y <- -x[6:10]
x <- c(x, y)
ts.match(x, y, 1)
z <- rnorm(5)
ts.match(x, z)
}
