% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_distance.R, R/reason_dataleaks.R
\name{reason_dataleaks}
\alias{reason_dataleaks}
\title{Correlation calculation based on rolling window with overlapping observations.}
\usage{
reason_dataleaks(lstx, finddataleaksout, h, ang = 0)

reason_dataleaks(lstx, finddataleaksout, h, ang = 0)
}
\arguments{
\item{lstx}{list of time series}

\item{finddataleaksout}{list, the output generated from find_dataleaks function}

\item{h}{length of the window size}

\item{ang}{angle at which the tick and axis labels should be displayed (default 0)}
}
\value{
matrix visualizing the output

matrix visualizing the output
}
\description{
Correlation calculation based on rolling window with overlapping observations.

Correlation calculation based on rolling window with overlapping observations.
}
\examples{
a = rnorm(15)
lst <- list(
 a = a,
 b = c(a[10:15], rnorm(10), a[1:5]+10, a[1:5]),
 c = c(rnorm(10), a[1:5])
)
f1 <- find_dataleaks(lst, h=5)
reason_dataleaks(lst, f1, h=5)

# List without naming elements
lst <- list(
 a,
 c(rnorm(10), a[1:5], a[1:5]),
 rnorm(10)
)
f2 <- find_dataleaks(lst, h=5)
reason_dataleaks(lst, f2, h=5)
a = rnorm(15)
lst <- list(
 a = a,
 b = c(a[10:15], rnorm(10), a[1:5], a[1:5]),
 c = c(rnorm(10), a[1:5])
)
f1 <- find_dataleaks(lst, h=5)
reason_dataleaks(lst, f1, h=5)
}
