% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence.R
\name{time_splits}
\alias{time_splits}
\title{Generate Train/Test Splits}
\usage{
time_splits(
  x,
  start = x[1],
  test_length = 1,
  by = test_length,
  window_size = NULL,
  calendar_end = NULL,
  complete_index = TRUE,
  ...
)
}
\arguments{
\item{x}{a vector of timestamps (POSIXct) or dates (Date) in the dataset}

\item{start}{starting date (first estimation/train date)}

\item{test_length}{type of calendar period to split on}

\item{by}{every how many periods to split on}

\item{window_size}{the size of the training set (for moving window). If NULL
will use an expanding window.}

\item{calendar_end}{an optional function to use for the period ending split,
such as \code{\link{calendar_eow}}, applied to x. This should be greater in
frequency than the underlying frequency of x (i.e. do not use calendar_eow on
monthly indices). This overwrites the use of window_size.}

\item{complete_index}{whether to return the full indices for train and test else
just the start and end indices.}

\item{\dots}{any additional parameters passed to the calendar_end function. For
example, the \dQuote{day} argument when using the calendar_eow function.}
}
\value{
A list with each slot having the training dates and test dates
}
\description{
Generates train/test splits given a vector of dates and other options
}
\note{
For months, quarters and years this will split into the end date of
these. For splitting into mins or hours, x must also have this resolution else
will throw an error. Additionally, the strict requirement of regularly spaced
time is required (no gaps).
}
\author{
Alexios Galanos
}
