#'Gives the starting coefficients from fitting a maximum likelihood model for truncated regression, assuming Gaussian errors
#'
#'Gives the starting coefficients from fitting a maximum likelihood model for truncated regression, assuming Gaussian errors.
#'Uses the \code{\link[truncreg]{truncreg}} function from the \code{truncreg} package.
#'@param mf model frame
#'@param mf_orig original model frame (before possible manipulations due to non-default truncation point or direction) used to ensure correct order of attributes in the call to \code{\link[truncreg]{truncreg}}
#'@export
#'@importFrom truncreg truncreg
#'@author Anita Lindmark and Maria Karlsson
#'

mlcoef <- function(mf, mf_orig)
{
  mlc <- truncreg(attributes(mf_orig), data = mf, point = 0, direction = "left")$coef
  return(mlc)
}
