% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cpv}
\alias{combination}
\alias{combinations}
\alias{cpv}
\title{Combinations Pseudo-Vector Constructor}
\usage{
cpv(k, items)
}
\arguments{
\item{k}{the number of objects taken at a time.}

\item{items}{a vector of objects to be combined.}
}
\value{
an instance of \code{CPV}.
}
\description{
The \code{CPV} class defines a pseudo-vector containing all
the arranged \code{k}-combinations of the objects stored
in \code{items}. The function \code{cpv} is a constructor for this class.
}
\details{
The combinations are arranged according to the order in which the objects
appear in \code{items}. Combinations containing the first object in
\code{items} are followed by combinations that contain the second object
but not the first, which are followed by combinations that contain the third
but neither the first or the second, etc.
}
\examples{
# create a pseudo-vector of 10-combinations from the first 15 letters
c <- cpv(10, letters[1:15])
# generate a description
print(c)
# compatable with length
length(c)
# inspect a few of the combinations "stored" in c
c[1]
c[1000]
c[3003]
}
\author{
Richard Ambler
}
\references{
Steinhaus-Johnson-Trotter algorithm. (2014, April 29).
In \emph{Wikipedia, The Free Encyclopedia}.
Retrieved 13:24, September 5, 2014
}
\seealso{
Permutations Pseudo-Vector \code{\link{ppv}}

Amalgams Pseudo-Vector \code{\link{apv}}

Selections Pseudo-Vector \code{\link{spv}}

Subsets Pseudo-Vector \code{\link{sspv}}
}

