% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle-utils.R
\name{summary.triangle_mle}
\alias{summary.triangle_mle}
\alias{print.triangle_mle}
\alias{coef.triangle_mle}
\alias{logLik.triangle_mle}
\alias{AIC.triangle_mle}
\alias{BIC.triangle_mle}
\alias{vcov.triangle_mle}
\alias{profile.triangle_mle}
\alias{confint.triangle_mle}
\title{Utility Methods for S3 class triangle_mle}
\usage{
\method{summary}{triangle_mle}(object, ...)

\method{print}{triangle_mle}(x, ...)

\method{coef}{triangle_mle}(object, ...)

\method{logLik}{triangle_mle}(object, ...)

\method{AIC}{triangle_mle}(object, ..., k = 2)

\method{BIC}{triangle_mle}(object, ...)

\method{vcov}{triangle_mle}(object, ...)

\method{profile}{triangle_mle}(fitted, ...)

\method{confint}{triangle_mle}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{class triangle_mle from a call to \code{triangle_mle()}}

\item{...}{not used except for \code{print} (other arguments passed to \code{printCoefmat})}

\item{x}{the \code{triangle_mle} object}

\item{k}{the penalty per parameter to be used; the default k = 2}

\item{fitted}{an object of class triangle_mle}

\item{parm}{parameters}

\item{level}{confidence interval level}
}
\value{
an object of class summary.mle

x invisibly

a vector of coefficients

an object of class logLik

the AIC

the BIC

the variance co-variance matrix

an object of class profile.mle

an object of class profile.mle
}
\description{
Utility Methods for S3 class triangle_mle
}
\examples{
set.seed(1234)
x <- rtriangle(100, 0, 1, 0.5)
mle1 <- triangle_mle(x)
summary(mle1)
print(mle1)
coef(mle1)
logLik(mle1)
AIC(mle1)
BIC(mle1)
vcov(mle1)
\dontrun{
  prof <- profile(mle1)
  stats4::plot(prof)
  confint(mle1, 1:3, level = 0.95)
}
}
