% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_count_two_group_tests.R
\encoding{UTF-8}
\name{run_count_two_group_tests}
\alias{run_count_two_group_tests}
\title{Statistical Test for Count Data (Two Groups) / Statistischer Test fuer Zaehldaten (Zwei Gruppen)}
\usage{
run_count_two_group_tests(
  df,
  value_col = ".value",
  group_col = "jahr",
  alpha = 0.05,
  phi = 1.5,
  effect_size = FALSE,
  report_assumptions = TRUE
)
}
\arguments{
\item{df}{A data frame containing the data, already prepared (e.g., by prepare_group_data).}

\item{value_col}{Name of the column containing count values. Default is ".value".}

\item{group_col}{Name of the grouping variable. Default is "jahr".}

\item{alpha}{Significance level for hypothesis testing. Default is 0.05.}

\item{phi}{Common heuristic for overdispersion. Default is 1.5.}

\item{effect_size}{Logical. Whether to calculate and return a simple effect size (e.g., Incidence Rate Ratio).}

\item{report_assumptions}{Logical. Whether to report basic assumption diagnostics (e.g., overdispersion status).}
}
\value{
A list containing test results (p-value, direction, chosen method),
        basic statistics, and confidence intervals.
}
\description{
This function performs a simple comparison of count data between two groups.
It uses Poisson or Negative Binomial regression based on overdispersion,
focusing on providing a p-value and direction of difference without complex model interpretation.
Now includes basic descriptive statistics and confidence intervals.
}
\details{
Diese Funktion fuehrt einen einfachen Vergleich von Zaehldaten zwischen zwei Gruppen durch.
Sie verwendet Poisson- oder Negative Binomial-Regression (abhaengig von Ueberdispersion),
wobei der Schwerpunkt auf der Bereitstellung eines p-Wertes und der Richtung des Unterschieds liegt,
ohne komplexe Modellinterpretation. Nun auch mit grundlegenden deskriptiven Statistiken und Konfidenzintervallen.
}
