% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_groupcol.R
\encoding{UTF-8}
\name{filter_by_groupcol}
\alias{filter_by_groupcol}
\title{Filter and optionally reshape a data frame by group column / Nach Gruppenspalte filtern und optional umstrukturieren}
\usage{
filter_by_groupcol(
  df,
  group_col,
  value_col,
  datum_col,
  keep_levels = NULL,
  to_wide = FALSE,
  keep_other_cols = FALSE
)
}
\arguments{
\item{df}{A data.frame or tibble containing the data.}

\item{group_col}{A string specifying the grouping column (e.g., "region", "age_group").}

\item{value_col}{A string for the value column (default: "neue_faelle").}

\item{datum_col}{A string for the date column (default: "datum").}

\item{keep_levels}{Optional vector of levels to retain in group_col. Default = NULL (keep all).}

\item{to_wide}{Logical, if TRUE returns a wide-format table (each level a column).}

\item{keep_other_cols}{Logical, if TRUE keeps all other original columns.}
}
\value{
A filtered and optionally reshaped tibble.
}
\description{
This function filters a data frame based on specified grouping levels and
optionally transforms it into a wide format for further analysis.
It supports retaining extra columns and provides robust error checking.
}
\details{
Diese Funktion filtert einen Data Frame basierend auf bestimmten Gruppenwerten
und kann ihn optional in ein Wide-Format umwandeln. Es koennen weitere Spalten
beibehalten werden, und die Funktion enthaelt robuste Fehlerpruefungen.


This function is particularly useful for preparing time series grouped by categories, such as cases per region or age group.

Diese Funktion eignet sich besonders zur Vorbereitung gruppierter Zeitreihen, z.B. nach Region oder Altersgruppe.
}
\examples{
# English / Deutsch
df <- data.frame(
  datum = as.Date("2024-01-01") + 0:9,
  gruppe = rep(c("A", "B"), each = 5),
  neue_faelle = c(10, 12, 13, 15, 11, 20, 21, 22, 19, 18),
  region = rep("Berlin", 10)
)

filter_by_groupcol(
  df,
  group_col = "gruppe",
  value_col = "neue_faelle",
  datum_col = "datum",
  keep_levels = "A"
)

filter_by_groupcol(
  df,
  group_col = "gruppe",
  value_col = "neue_faelle",
  datum_col = "datum",
  to_wide = TRUE
)

}
