% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-basic.R
\name{rebase}
\alias{rebase}
\alias{rebase_origin}
\title{Change the base year}
\usage{
rebase(x, n = NULL)

rebase_origin(x)
}
\arguments{
\item{x}{\verb{[univariate vector]}

Univariate vector, numeric or ts object with only one dimension.}

\item{n}{\verb{[numeric(1): NULL]}

The index of the new base year.}
}
\value{
Returns a vector with the same class and attributes as the input vector.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}

Change the base year.
}
\examples{

x <- 3:10

# New base  would be 5
rebase(x, 5)

# Or the origin
rebase_origin(x)

# Fro the base to be 100 or 0 then:
rebase(x, 5)*100
rebase(x, 5) - 1
}
