% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{is_int}
\alias{is_int}
\alias{is_chr}
\alias{is_lgl1}
\alias{is_int1}
\alias{is_chr1}
\alias{is_list}
\alias{is_between}
\alias{is_named}
\alias{is_match}
\alias{assert_int}
\alias{assert_chr}
\alias{assert_lgl1}
\alias{assert_int1}
\alias{assert_chr1}
\alias{assert_list}
\alias{assert_between}
\alias{assert_named}
\alias{assert_match}
\alias{assert_arg}
\alias{assert}
\alias{assert.default}
\title{Assertions}
\usage{
is_int(x, allow_empty = FALSE)

is_chr(x, allow_empty = FALSE)

is_lgl1(x)

is_int1(x)

is_chr1(x, allow_empty_string = FALSE)

is_list(x, allow_empty = FALSE)

is_between(x, min = -Inf, max = Inf)

is_named(x, allow_empty_names = FALSE, allow_na_names = FALSE)

is_match(x, choices = vector(), allow_partial = FALSE)

assert_int(
  x,
  allow_empty = FALSE,
  throw_error = TRUE,
  x_name = deparse(substitute(x))
)

assert_chr(
  x,
  allow_empty = FALSE,
  throw_error = TRUE,
  x_name = deparse(substitute(x))
)

assert_lgl1(x, throw_error = TRUE, x_name = deparse(substitute(x)))

assert_int1(x, throw_error = TRUE, x_name = deparse(substitute(x)))

assert_chr1(
  x,
  allow_empty_string = FALSE,
  throw_error = TRUE,
  x_name = deparse(substitute(x))
)

assert_list(
  x,
  allow_empty = FALSE,
  throw_error = TRUE,
  x_name = deparse(substitute(x))
)

assert_between(
  x,
  min = -Inf,
  max = Inf,
  throw_error = TRUE,
  x_name = deparse(substitute(x))
)

assert_named(
  x,
  allow_empty_names = FALSE,
  allow_na_names = FALSE,
  throw_error = TRUE,
  x_name = deparse(substitute(x))
)

assert_match(
  x,
  choices,
  allow_partial = FALSE,
  quote_values = FALSE,
  throw_error = TRUE,
  x_name = deparse(substitute(x))
)

assert_arg(x, quote_values = FALSE, throw_error = TRUE)

assert(x, ...)

\method{assert}{default}(x, ...)
}
\arguments{
\item{x}{Any \R object.}

\item{allow_empty}{A non-NA logical value. Should vectors of length 0 be
considered as valid values?}

\item{allow_empty_string}{A non-NA logical value. Should empty character
strings be considered as valid values?}

\item{min}{A non-NA numeric lower bound. It can be infinite.}

\item{max}{A non-NA numeric upper bound. It can be infinite.}

\item{allow_empty_names}{A non-NA logical value. Should empty character
strings be considered as valid names? This is different from having no
names at all.}

\item{allow_na_names}{A non-NA logical value. Should NA values be considered
as valid names?}

\item{choices}{A non-empty \link[base:vector]{vector} of valid candidates.}

\item{allow_partial}{A non-NA logical value. Should \code{x} be partially matched?}

\item{throw_error}{A non-NA logical value. Should an error be thrown? If so,
\code{\link[=stops]{stops()}} is called. Otherwise, error messages are returned as a character
vector (possibly empty).}

\item{x_name}{A non-empty and non-NA character string. The name of \code{x}.}

\item{quote_values}{A non-NA logical value. Passed as is to \code{\link[=str_to]{str_to()}}.}
}
\value{
\code{\link[=is_int]{is_int()}},
\code{\link[=is_chr]{is_chr()}},
\code{\link[=is_lgl1]{is_lgl1()}},
\code{\link[=is_int1]{is_int1()}},
\code{\link[=is_chr1]{is_chr1()}},
\code{\link[=is_list]{is_list()}},
\code{\link[=is_between]{is_between()}},
\code{\link[=is_named]{is_named()}}, and
\code{\link[=is_match]{is_match()}} return a logical value.

\code{\link[=assert]{assert()}},
\code{\link[=assert_int]{assert_int()}},
\code{\link[=assert_chr]{assert_chr()}},
\code{\link[=assert_lgl1]{assert_lgl1()}},
\code{\link[=assert_int1]{assert_int1()}},
\code{\link[=assert_chr1]{assert_chr1()}},
\code{\link[=assert_list]{assert_list()}},
\code{\link[=assert_between]{assert_between()}},
\code{\link[=assert_named]{assert_named()}},
\code{\link[=assert_match]{assert_match()}}, and
\code{\link[=assert_arg]{assert_arg()}} return an empty character vector if \code{x} meets the underlying
criteria and throw an error otherwise. If \code{throw_error} is \code{FALSE}, the
error message is returned as a character vector. Unless otherwise stated,
the latter is of length 1 (a character string).

\code{\link[=assert.default]{assert.default()}} always returns an empty character vector.
}
\description{
These functions are a functional implementation of defensive programming.

\verb{is_*()} functions check whether their argument meets certain criteria.

\verb{assert_*()} functions further throw an error message when at least one
criterion is not met.

\strong{Arguments listed below are not explicitly validated for efficiency.}
}
\details{
Guard clauses tend to be verbose and recycled many times within a project.
This makes it hard to keep error messages consistent over time. \verb{assert_*()}
functions encapsulate usual guard clause into simple semantic functions.
This reduces code repetition and number of required unit tests. See
Examples below.

By convention, NA values are \strong{always} disallowed.

\code{\link[=assert_arg]{assert_arg()}} is a partial refactoring of \code{\link[base:match.arg]{base::match.arg()}}. It relies
on \code{\link[=assert_match]{assert_match()}} internally and does not have an equivalent \code{is_arg()}
function. It must be called within another function.

\code{\link[=assert]{assert()}} is a S3 generic function that covers specific data structures.
Classes (and underlying objects) that do not have an \code{\link[=assert]{assert()}} method are
considered to be valid by default.
}
\keyword{internal}
