% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_ladders.R
\name{find_ladders}
\alias{find_ladders}
\title{Ladder and bp sizing}
\usage{
find_ladders(fragments_list, config, ...)
}
\arguments{
\item{fragments_list}{list from 'read_fsa' function}

\item{config}{A trace_config object generated using \code{\link[=load_config]{load_config()}}.}

\item{...}{additional parameters from any of the functions in the pipeline detailed below may be passed to this function. This overwrites values in the \code{config}. These parameters include:
\itemize{
\item \code{ladder_channel}: string, which channel in the fsa file contains the ladder signal. Default: \code{"DATA.105"}.
\item \code{signal_channel}: string, which channel in the fsa file contains the data signal. Default: \code{"DATA.1"}.
\item \code{ladder_sizes}: numeric vector, bp sizes of ladder used in fragment analysis. Default: \code{c(50, 75, 100, 139, 150, 160, 200, 250, 300, 340, 350, 400, 450, 490, 500)}.
\item \code{ladder_start_scan}: single numeric indicating the scan number to start looking for ladder peaks (only required when ladder signal does not have large spike at start). Usually this can be automatically found (when set to NA) through the detection of the large spike at the start of the signal. Default: \code{NA}.
\item \code{minimum_ladder_signal}: single numeric for minimum signal of peak from smoothed signal. Default: \code{NA}.
\item \code{ladder_assign_left_to_right}: single logical for if the ladder should be assigned from the smallest base pair size to largest (TRUE), or if the order should be reversed and assigned from largest to smallest (FALSE), which can be helpful since the end often has cleaner signal than the start. Default: \code{TRUE}.
\item \code{ladder_selection_window}: single numeric for the ladder assigning algorithm. We iterate through the scans in blocks and test their linear fit (We can assume that the ladder is linear over a short distance). This value defines how large that block of peaks should be. Larger values should be better because the fit is tested in greater context, but larger numbers will make the fit increasingly slower. Default: \code{5}.
\item \code{ladder_top_n_branching}: single numeric. The ladder assigning algorithm branches as it tests the various combinations. This value defines how many branches should be created. If the correct combination is not found, you could try increasing this value, but it will make it increasingly slower. Default: \code{5}.
\item \code{ladder_branching_r_squared_threshold}: single numeric. The branches of the ladder assigning algorithm are pruned by R-squared values above this threshold to discard fits that are not promising. If the correct combination is not found, you could try decreasing this value, but it will make it increasingly slower. Default: \code{0.99}.
\item \code{min_scan}: single numeric indicating the lower scan limit to filter out scans below. Default: \code{NA}.
\item \code{max_scan}: single numeric indicating the upper scan limit to filter out scans above Default: \code{NA}.
\item \code{max_combinations}: single numeric indicating what is the maximum number of ladder combinations that should be tested. Default: \code{2500000}.
\item \code{warning_rsq_threshold}: single numeric for the value for which this function will warn you when parts of the ladder have R-squared values below the specified threshold. Default: \code{0.998}.
\item \code{show_progress_bar}: single logical for showing progress bar. Default: \code{TRUE}.
}}
}
\value{
This function modifies list of fragments objects in place with the ladder assigned and base pair calculated.
}
\description{
Find the ladder peaks in and use that to call bp size
}
\details{
This function takes a list of fragments files (the output from read_fsa) and identifies
the ladders in the ladder channel which is used to call the bp size. The output
is a list of fragments.

In this package, base pair (bp) sizes are assigned using a generalized additive model (GAM) with cubic regression splines. The model is fit to known ladder fragment sizes and their corresponding scan positions, capturing the relationship between scan number and bp size. Once trained, the model predicts bp sizes for all scans by interpolating between the known ladder points. This approach provides a flexible and accurate assignment of bp sizes, accommodating the slightly non-linear relationship.

Use \code{\link[=plot_data_channels]{plot_data_channels()}} to plot the raw data on the fsa file to identify which channel the ladder and data are in.

Each ladder should be manually inspected to make sure that is has been correctly assigned.
}
\examples{

fsa_list <- lapply(cell_line_fsa_list[1], function(x) x$clone())
config <- load_config()

trace:::find_ladders(fsa_list, config, show_progress_bar = FALSE)

# Manually inspect the ladders
plot_ladders(fsa_list[1])

}
\seealso{
\code{\link[=plot_data_channels]{plot_data_channels()}} to plot the raw data in all channels. \code{\link[=plot_ladders]{plot_ladders()}} to plot the assigned ladder
peaks onto the raw ladder signal. \code{\link[=fix_ladders_interactive]{fix_ladders_interactive()}} to fix ladders with
incorrectly assigned peaks.
}
\keyword{internal}
