% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{hpms}
\alias{hpms}
\title{Generate an HPMS Submission File}
\usage{
hpms(
  file,
  tmc_identification,
  lottr_scores,
  tttr_scores,
  phed_scores = NULL,
  occ_fac = 1.7
)
}
\arguments{
\item{file}{Output file name. This is the HPMS submittal file.}

\item{tmc_identification}{Path to TMC_Identification.csv file provided by RITIS with travel time download}

\item{lottr_scores}{A data.table of LOTTR scores produced using \code{score(..., metric == "LOTTR")}}

\item{tttr_scores}{A data.table of TTTR scores produced using \code{score(..., metric == "TTTR")}}

\item{phed_scores}{A data.table of of PHED scores produced using \code{phed()}}

\item{occ_fac}{Occupancy factor. Default = 1.7}
}
\value{
No return value, writes file to disk
}
\description{
Generate an HPMS submission file in accordance with
\href{https://www.fhwa.dot.gov/tpm/guidance/pm3_hpms.pdf}{HPMS Field Manual Supplemental Guidance}
Requires the scores from score() to be run with verbose = TRUE
The reporting year is based on the TMC_Identification year (e.g. use 2021 TMC network for 2021 reporting in 2022)
Writes the resulting file to hpms_year.txt
}
\examples{
\dontrun{
lottr_scores <- lottr("data/All_Vehicles/al_tt_seconds.csv", verbose = TRUE)
tttr_scores <- tttr("data/Trucks/aldot_2019_trucks.csv", verbose = TRUE)
phed_scores <- phed("Readings.csv", "TMC_Identification.csv",
                    speed_limits = fread("speed_limits.csv"),
                    urban_code = 56139, pm_peak = 3, population = 52898)
hpms("hpms_2020.txt", "TMC_Identification.csv", lottr_scores, tttr_scores, phed_scores)
}

}
