% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{standardVar}
\alias{standardVar}
\title{Stardardise a matrix}
\usage{
standardVar(mat, centre = TRUE, normalise = FALSE)
}
\arguments{
\item{mat}{Matrix or vector to be standardise.}

\item{centre}{Logical, if true, cetre to mean zero.}

\item{normalise}{Logical, if true, performs vector normalisation.}
}
\value{
A matrix or vector with the preferred standardarisation
}
\description{
This function stardardises a matrix or a vector and gives the option to
centre or normalise (only vectors).
}
\examples{
#sample size etc
N = 10
p = 25
q = 5
# noise
X0 = sapply(1:p, function(x) rnorm(N))
Y0 = sapply(1:q, function(x) rnorm(N))

colnames(X0) = paste0("x", 1:p)
colnames(Y0) = paste0("y", 1:q)

# signal
Z1 = rnorm(N,0,1)


#Some associations with the true signal
alpha = (6:10) / 10
beta  = -(2:3) / 10

loc_alpha = 1:length(alpha)
loc_beta  = 1:length(beta)

for(j in 1:length(alpha))
  X0[, loc_alpha[j]] =  alpha[j] * Z1 + rnorm(N,0,0.3)

for(j in 1:length(beta))
  Y0[, loc_beta[j]] =  beta[j] * Z1 + rnorm(N,0,0.3)

X = standardVar(X0)
Y = standardVar(Y0)
}
