% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tomba.R
\name{count}
\alias{count}
\alias{count,Tomba-method}
\title{Email Count}
\usage{
count(obj, domain)

\S4method{count}{Tomba}(obj, domain)
}
\arguments{
\item{obj}{Tomba class}

\item{domain}{a character Domain name from which you want to find the email addresses. For example, "stripe.com".}
}
\value{
A list domain count data containing the: Total email,Total personal email,Total generic email,Total email on department \emph{key_name}.
}
\description{
\code{count} Returns total email addresses we have for one domain.
}
\examples{
\dontrun{
client <- Tomba(key="ta_xxxx",secret="ts_xxxx")
result <- count(client,domain="tomba.io")
}
}
\references{
\url{https://developer.tomba.io/#email-count}
}
