% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_polypath.R
\name{type_polypath}
\alias{type_polypath}
\title{Polypath polygon type}
\usage{
type_polypath(rule = "winding")
}
\arguments{
\item{rule}{character value specifying the path fill mode: either
    \code{"winding"} or \code{"evenodd"}.}
}
\description{
Type function for plotting polygons.
Arguments are passed to \code{\link[graphics]{polypath}}.
}
\examples{
# "polypath" type convenience character string
tinyplot(
    c(.1, .1, .6, .6, NA, .4, .4, .9, .9),
    c(.1, .6, .6, .1, NA, .4, .9, .9, .4),
    type = "polypath", fill = "grey"
)

# Use `type_polypath()` to pass extra arguments for customization
tinyplot(
    c(.1, .1, .6, .6, NA, .4, .4, .9, .9),
    c(.1, .6, .6, .1, NA, .4, .9, .9, .4),
    type = type_polypath(rule = "evenodd"), fill = "grey"
)
}
