% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_errorbar.R, R/type_pointrange.R
\name{type_errorbar}
\alias{type_errorbar}
\alias{type_pointrange}
\title{Error bar and pointrange plot types}
\usage{
type_errorbar(length = 0.05, dodge = 0, fixed.dodge = FALSE)

type_pointrange(dodge = 0, fixed.dodge = FALSE)
}
\arguments{
\item{length}{length of the edges of the arrow head (in inches).}

\item{dodge}{Adjustment parameter for dodging overlapping points or ranges in
grouped plots along the x-axis (or y-axis for flipped plots). Either:
\itemize{
\item numeric value in the range \verb{[0,1)}. Note that values are scaled
relative to the spacing of x-axis breaks, e.g. \code{dodge = 0.1} places the
outermost groups one-tenth of the way to adjacent breaks, \code{dodge = 0.5}
places them midway between breaks, etc. Values < 0.5 are recommended.
\item logical. If \code{TRUE}, the dodge width is calculated automatically based on
the number of groups (0.1 per group for 2-4 groups, 0.45 for 5+ groups). If
\code{FALSE} or 0, no dodging is performed.
}

Default value is 0 (no dodging). While we do not check, it is \emph{strongly}
recommended that dodging only be used in cases where the x-axis comprises a
limited number of discrete breaks.}

\item{fixed.dodge}{Logical. If \code{FALSE} (default), dodge positions are
calculated independently for each \code{x} value, based only on the groups
present at that position. If \code{TRUE}, dodge positions are based on all
groups, ensuring "fixed" spacing across x-axis breaks (i.e., even if some
groups are missing for a particular \code{x} value).}
}
\description{
Type function(s) for producing error bar and pointrange plots.
}
\examples{
tinytheme("basic")

#
## Basic coefficient plot(s)

mod = lm(mpg ~ wt * factor(am), mtcars)
coefs = data.frame(names(coef(mod)), coef(mod), confint(mod))
colnames(coefs) = c("term", "est", "lwr", "upr")

# "errorbar" and "pointrange" type convenience strings
tinyplot(est ~ term, ymin = lwr, ymax = upr, data = coefs, type = "errorbar")
tinyplot(est ~ term, ymin = lwr, ymax = upr, data = coefs, type = "pointrange")

# Use `type_errorbar()` to pass extra arguments for customization
tinyplot(est ~ term, ymin = lwr, ymax = upr, data = coefs,
         type = type_errorbar(length = 0.2))

#
## Flipped plots

# For flipped errobar / pointrange plots, it is recommended to use a dynamic
# theme that applies horizontal axis tick labels

tinytheme("classic")
tinyplot(est ~ term, ymin = lwr, ymax = upr, data = coefs, type = "errorbar",
         flip = TRUE)
tinyplot_add(type = 'vline', lty = 2)

tinytheme("basic") # back to basic theme for the remaining examples

#
## Dodging groups

models = list(
    "Model A" = lm(mpg ~ wt, data = mtcars),
    "Model B" = lm(mpg ~ wt + cyl, data = mtcars),
    "Model C" = lm(mpg ~ wt + cyl + hp, data = mtcars)
)

models = do.call(
  rbind,
  lapply(names(models), function(m) {
    data.frame(
      model = m,
      term = names(coef(models[[m]])),
      estimate = coef(models[[m]]),
      setNames(data.frame(confint(models[[m]])), c("conf.low", "conf.high"))
    )
  })
)

tinyplot(estimate ~ term | model,
         ymin = conf.low, ymax = conf.high,
         data = models,
         type = type_pointrange(dodge = 0.1))

# Aside 1: relative vs fixed dodge
#  The default dodge position is based on the unique groups (here: models)
#  available to each x value (here: coefficient term). To "fix" the dodge
#  position across all x values, use `fixed.dodge = TRUE`.

tinyplot(estimate ~ term | model,
         ymin = conf.low, ymax = conf.high,
         data = models,
         type = type_pointrange(dodge = 0.1, fixed.dodge = TRUE))

# Aside 2: layering
#  For layering on top of dodged plots, rather pass the dodging arguments
#  through the top-level call if you'd like the dodging behaviour to be
#  inherited automatically by the added layers.

tinyplot(estimate ~ term | model,
         ymin = conf.low, ymax = conf.high,
         data = models,
         type = "pointrange",
         dodge = 0.1, fixed.dodge = TRUE)
tinyplot_add(type = "l", lty = 2)

tinytheme() # reset theme

}
