% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gacbv_toc.R
\name{gacbv_toc}
\alias{gacbv_toc}
\alias{gacbv_toc_df}
\title{Calculate maximum bed volumes to stay below target DOC}
\source{
See references list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}

Zachman and Summers (2010)

USEPA (2001)
}
\usage{
gacbv_toc(
  water,
  ebct = 10,
  model = "Zachman",
  media_size = "12x40",
  target_doc
)

gacbv_toc_df(
  df,
  input_water = "defined",
  model = "use_col",
  media_size = "use_col",
  ebct = "use_col",
  target_doc = "use_col",
  water_prefix = TRUE
)
}
\arguments{
\item{water}{Source water object of class "water" created by \link{define_water}}

\item{ebct}{Empty bed contact time (minutes). Model results are valid for 10 or 20 minutes. Default is 10 minutes.}

\item{model}{Specifies which GAC TOC removal model to apply. Options are Zachman and WTP.}

\item{media_size}{Size of GAC filter mesh. Model includes 12x40 and 8x30 mesh sizes. Default is 12x40.}

\item{target_doc}{Optional input to set a target DOC concentration and calculate necessary bed volume}

\item{df}{a data frame containing a water class column, which has already been computed using
\link{define_water_df} The df may include columns named for the chemical(s) being dosed.}

\item{input_water}{name of the column of water class data to be used as the input for this function. Default is "defined".}

\item{water_prefix}{Append the output_water name to the start of the plucked columns. Default is TRUE.}
}
\value{
\code{gacbv_toc} returns a data frame of bed volumes that achieve the target DOC.

\code{gacbv_toc_df} returns a data frame with columns for bed volumes.
}
\description{
Calculates GAC filter bed volumes to achieve target effluent DOC according to the model developed in
"Modeling TOC Breakthrough in Granular Activated Carbon Adsorbers" by Zachman and Summers (2010), or the USEPA WTP Model v. 2.0 Manual (2001).
For a single water use \code{gacbv_toc}; for a dataframe use \code{gacbv_toc_df}.
For most arguments in the \verb{_df} helper
"use_col" default looks for a column of the same name in the dataframe. The argument can be specified directly in the
function instead or an unquoted column name can be provided.

Water must contain DOC or TOC value.
}
\details{
GAC model for TOC removal

The function will calculate bed volume required to achieve given target DOC values.
}
\examples{
water <- define_water(ph = 8, toc = 2.5, uv254 = .05, doc = 1.5)
bed_volume <- gacbv_toc(water, media_size = "8x30", ebct = 20, model = "Zachman", target_doc = 0.8)

\donttest{
library(dplyr)

example_df <- water_df \%>\%
  define_water_df() \%>\%
  dplyr::mutate(
    model = "WTP",
    media_size = "8x30",
    ebct = 10,
    target_doc = rep(c(0.5, 0.8, 1), 4)
  ) \%>\%
  gacbv_toc_df()
}

}
