% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{schema_api}
\alias{schema_api}
\alias{add_schema}
\alias{update_schema}
\alias{reset_schema}
\title{Add, update, or reset a \code{schema} object within an existing \code{roadmap}.}
\usage{
add_schema(roadmap, schema)

update_schema(roadmap, ...)

reset_schema(roadmap)
}
\arguments{
\item{roadmap}{A \code{roadmap} object}

\item{schema}{A \code{schema} object.}

\item{...}{Optional named parameters passed to \code{schema()}.}
}
\value{
A new \code{roadmap} object.

A roadmap object with added schema.

A roadmap object with updated schema.

A roadmap object with reset schema.
}
\description{
Add, update, or reset a \code{schema} object within an existing \code{roadmap}.
}
\examples{

rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
)

acs_schema <- schema(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw,
  na_numeric_to_ind = TRUE
)

rm |>
  add_schema(schema = acs_schema)


rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
)

rm |>
  update_schema(na_numeric_to_ind = TRUE)


rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
)

rm <- rm |>
  update_schema(na_numeric_to_ind = TRUE)

reset_schema(roadmap = rm)
  
}
