% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_pca.R
\name{spec_pca}
\alias{spec_pca}
\title{Perform Principal Component Analysis (PCA) on Spectral Data}
\usage{
spec_pca(.data, wn_col = NULL, scale = TRUE, center = TRUE)
}
\arguments{
\item{.data}{A data frame containing spectral data, with one column representing
wavenumbers and the remaining columns containing spectral intensity values.}

\item{wn_col}{A string specifying the name of the column that contains the
wavenumber values. If NULL, the function attempts to retrieve the default
wavenumber column set by `set_spec_wn()`.}

\item{scale}{A logical value indicating whether the spectral data should be
scaled (default is TRUE).}

\item{center}{A logical value indicating whether the spectral data should be
centered (default is TRUE).}
}
\value{
A `prcomp` object containing the PCA results, including principal
  components, standard deviations, and loadings.
}
\description{
This function computes a Principal Component Analysis (PCA) on spectral data,
excluding the wavenumber column from the analysis.
}
\examples{
\donttest{
set_spec_wn("Wavenumber")
pca_result <- spec_pca(CoHAspec)
summary(pca_result)
}

}
