% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tunable.R
\name{neighborhood}
\alias{neighborhood}
\title{Neighborhood size}
\usage{
neighborhood(range = c(2L, dials::unknown()), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the defaults for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the transformed units.}

\item{trans}{A trans object from the scales package, such as
scales::log10_trans() or scales::reciprocal_trans().If not provided, the
default is used which matches the units used in range. If no transformation,
NULL.}
}
\value{
An S3 class of type quant_param from the dials package.
}
\description{
Number of data points used to calculate the shape of the
neighborhood.
}
\details{
Use get_n or finalize from dials to finalize.

If cross validation is done, use get_n_frac with argument frac set to 1/V.
See README for detailed example.
}
\examples{
library(dials)
library(tidydann)

data("taxi", package = "modeldata")
neighborhood() |> finalize(taxi)

neighborhood() |> get_n(taxi)
}
