% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_chart_stacked.R
\name{line_chart_stacked}
\alias{line_chart_stacked}
\title{Generates areas (stacked lines) plot. If more than one series is supplied, stacked areas plot is generated.}
\usage{
line_chart_stacked(
  data,
  cat,
  series,
  series_labels,
  show_labels,
  interval = "months"
)
}
\arguments{
\item{data}{data frame containing data to be plotted}

\item{cat}{vector containing time intervals of the values}

\item{series}{vector containing names of columns in data with values to plot}

\item{series_labels}{vector containing names of series to be shown on the plot}

\item{show_labels}{vector of the same length as cat containing NA or not NA values defining which categories should have labels of values displayed}

\item{interval}{intervals on x axis. The width of the bars depends on this parameter}
}
\value{
object of class tidychart with a character vector containing SVG elements
}
\description{
Generates areas (stacked lines) plot. If more than one series is supplied, stacked areas plot is generated.
}
\examples{

#preparing data frames
data <- data.frame(
weeks =    c(28,   29, 30,  31,  32,  33,  34,  35,  36, 37),
Services = c(130,150, 182, 170, 170, 140, 130, 130, 135, 140),
Software = c(100, 88, 83,   90, 92,   95, 129, 130, 130, 135),
Products = c(20,  35, 36,    40, 22,  25, 24,   19,  36,  40)
)

#defining the rest of the arguments
series <- c("Software", "Services", "Products")
labels <- c(NA, 1, NA, 1, NA, NA, 1, NA, 1, NA)

#generating the SVG string
line_chart_stacked <- line_chart_stacked(data, data$weeks, series, series, labels, "weeks")

#show the plot
line_chart_stacked

}
