% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar_chart.R
\name{bar_chart}
\alias{bar_chart}
\title{Generates basic horizontal barchart. If more than one series is supplied, stacked barchart is generated.}
\usage{
bar_chart(data, cat, series, series_labels = series, styles = NULL)
}
\arguments{
\item{data}{data frame containing data to be plotted}

\item{cat}{vector containing category names of values}

\item{series}{vector containing names of columns in data with values to plot}

\item{series_labels}{vector containing names of series to be shown on the plot}

\item{styles}{optional vector with styles of bars}
}
\value{
object of class tidychart with a character vector containing SVG elements
}
\description{
Generates basic horizontal barchart. If more than one series is supplied, stacked barchart is generated.
}
\examples{
#prepare the data frame
data <- data.frame(
city = c("Berlin", "Munich", "Cologne", "London", "Vienna", "Paris", "Zurich"),
Products = c(538, 250, 75, 301, 227, 100, 40),
Services = c(621, 545, 302, 44, 39, 20, 34)
)
#generate svgstring
barchart <- bar_chart(data, data$city, c("Products", "Services"), c("Products", "Services"))

#show the plot
barchart


}
