% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{AHP}
\alias{AHP}
\title{Select best model using analytic hyrarchy process}
\usage{
AHP(
  fitindices,
  relative_importance = c(AIC = 0.2323, AWE = 0.1129, BIC = 0.2525, CLC = 0.0922, KIC =
    0.3101)
)
}
\arguments{
\item{fitindices}{A matrix or data.frame of fit indices, with colnames
corresponding to the indices named in \code{relative_importance}.}

\item{relative_importance}{A named numeric vector. Names should correspond to
columns in \code{fitindices}, and values represent the relative weight
assigned to the corresponding fit index. The default value corresponds to the
fit indices and weights assigned by Akogul and Erisoglu. To assign uniform
weights (i.e., each index is weighted equally), assign an equal value to all.}
}
\value{
Numeric.
}
\description{
Integrates information from several fit indices, and selects the best model.
}
\details{
Many fit indices are available for model selection. Following
the procedure developed by Akogul and Erisoglu (2017), this function
integrates information from several fit indices, and selects the best model,
using Saaty's (1990) Analytic Hierarchy Process (AHP). Conceptually, the
process consists of the following steps:
\enumerate{
\item For each fit index, calculate the amount of support provided for each
model, relative to the other models.
\item From these comparisons, obtain a "priority vector" of the amount of
support for each model.
\item Compute a weighted average of the priority vectors for all fit indeces,
with weights based on a simulation study examining each fit index' ability to
recover the correct number of clusters (Akogul & Erisoglu, 2016).
\item Select the model with the highest weighted average priority.
}
}
\examples{
iris[,1:4] \%>\%
  estimate_profiles(1:4) \%>\%
  get_fit() \%>\%
  AHP()
}
\author{
Caspar J. van Lissa
}
