% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/position.R
\name{from_position}
\alias{from_position}
\title{Resolve a Position to Three Identifying Words}
\usage{
from_position(key, positions, ...)
}
\arguments{
\item{key}{an API key obtained from \href{http://developer.what3words.com/}{what3words}.}

\item{positions}{either a vector containing a single latitude/longitude pair, or a \emph{list} of vectors
for vectorised operations.}

\item{...}{further arguments to pass to httr's GET.}
}
\value{
A list containing the words, positions and language of those words.
}
\description{
\code{from_position} takes latitude/longitude pair (or sequence of them) and
resolves them to a word cluster used by what3words.
}
\examples{
\dontrun{
# Ask for a single set of words from the what3words API (note: this requires an API key.
# Don't actually use 'ANAPIKEY'.)
results <- from_position(key = "ANAPIKEY", positions = c(6.385336,-36.293769))
}
}
\seealso{
\code{\link{from_position}} for the opposite operation.
}

