% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_volume-slices.R
\name{plot_slices}
\alias{plot_slices}
\title{Plot slices of volume}
\usage{
plot_slices(
  volume,
  overlays = NULL,
  transform = NULL,
  positions = NULL,
  zoom = 1,
  pixel_width = 0.5,
  col = c("black", "white"),
  normalize = NULL,
  zclip = NULL,
  overlay_alpha = 0.3,
  zlim = normalize,
  main = "",
  title_position = c("left", "top"),
  fun = NULL,
  nc = NA,
  which = NULL,
  ...
)
}
\arguments{
\item{volume}{path to volume (underlay)}

\item{overlays}{images to overlay on top of the underlay, can be either
a vector of paths to the overlay volume images, or a sequence of named lists.
Each list item has \code{'volume'} (path to the volume) and \code{'color'}
(color of the overlay)}

\item{transform}{rotation of the volume in scanner \code{'RAS'} space}

\item{positions}{vector of length 3 or matrix of 3 columns, the \code{'RAS'}
position of cross-hairs}

\item{zoom}{zoom-in radio, default is 1}

\item{pixel_width}{output image pixel resolution; default is \code{0.5},
one pixel is 0.5 millimeters wide}

\item{col}{color palette, can be a sequence of colors}

\item{normalize}{range for volume data to be normalized; either \code{NULL}
(no normalize) or a numeric vector of length two}

\item{zclip}{clip image densities; if specified, values outside of this
range will be clipped into this range}

\item{overlay_alpha}{transparency of the overlay; default is 0.3}

\item{zlim}{image plot value range, default is identical to \code{normalize}}

\item{main}{image titles}

\item{title_position}{title position; choices are \code{"left"} or \code{"top"}}

\item{fun}{function with two arguments that will be executed after each
image is drawn; can be used to draw cross-hairs or annotate each image}

\item{nc}{number of "columns" in the plot when there are too many positions,
must be positive integer; default is \code{NA} (automatically determined)}

\item{which}{which plane to plot; default is \code{NULL}, which will trigger
new plots and add titles; set to \code{1} for \code{'Axial'} plane,
\code{2} for \code{'Sagittal'}, and \code{3} for \code{'Coronal'}.}

\item{...}{additional arguments passing into \code{\link[graphics]{image}}}
}
\value{
Nothing
}
\description{
Plot slices of volume
}
