% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsaggregates.R
\name{tsaggregates}
\alias{tsaggregates}
\title{Non-overlapping temporal aggregation of a time series}
\usage{
tsaggregates(y, m = frequency(y), align = c("end", "start"),
  aggregatelist = NULL)
}
\arguments{
\item{y}{Univariate time series of class \code{ts}.}

\item{m}{Integer seasonal period}

\item{align}{Indicates how the aggregates are to be aligned:
either with the \code{start} of the series or the \code{end} of the series.
For forecasting purposes, it should be set to \code{end}.}

\item{aggregatelist}{User-selected list of aggregates to consider.}
}
\value{
A list of time series. The first element is the series `y`,
followed by series with increasing levels of aggregation. The last
element is the "annual" series (i.e., the series aggregated over all seasons).
}
\description{
Produces all temporal aggregations for frequencies greater than 1
}
\examples{
tsaggregates(USAccDeaths)

}
\seealso{
\code{\link{plot.tsaggregates}}
}
\author{
Rob J Hyndman
}
