% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_dept.R
\name{list_dept}
\alias{list_dept}
\title{List departments with aggregations}
\usage{
list_dept(
  region_names = "all",
  city_names = "all",
  university_names = "all",
  department_names,
  lang = "en",
  aggregation
)
}
\arguments{
\item{region_names}{The region names that you want to get university,department and faculty names for.}

\item{city_names}{The city names that you want to get university,department and faculty names for.}

\item{university_names}{The university names that you want to get department and faculty names for.}

\item{department_names}{The department names that.}

\item{lang}{Language option. Default "en", "en" for English, "tr" for Turkish}

\item{aggregation}{"count_by_region" for group sum of universities per each region defined by user.}
}
\value{
A data frame
}
\description{
List universities, departments and faculties based on city, university and region filter.
}
\examples{
dept_names <- list_dept(region_names = "all", 
city_names = c("Izmir", "Mugla"), 
department_names = "Statistics")
}
