% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detvar.R
\name{InterventionVar}
\alias{InterventionVar}
\title{Intervention variables}
\usage{
InterventionVar(Y, date, type = c("P", "S", "R"), n.ahead = 0)
}
\arguments{
\item{Y}{A `ts` object used to determine start, length and frequency.}

\item{date}{Either a single positive index within the sample, or a vector
`c(year, month)` for monthly series. For non-seasonal series, `c(year)` is
also accepted.}

\item{type}{One of `"P"` (pulse), `"S"` (step), or `"R"` (ramp = cumulative
step).}

\item{n.ahead}{Integer. Extra observations to extend the sample.}
}
\value{
A `ts` intervention variable.
}
\description{
`InterventionVar()` creates pulse, step, or ramp variables at a given date.
}
\examples{
# Pulse at March 1958:
P <- InterventionVar(AirPassengers, date = c(1958, 3), type = "P")
# Or by index within the extended sample (here no extension):
P2 <- InterventionVar(AirPassengers, date = 123, type = "P")

}
\references{
Box, G.E.P. and Tiao, G.C. (1975) “Intervention analysis with
  applications to economic and environmental problems”, *JASA*, 70(349),
  70–79.
}
