% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers.R
\name{optimizer_yogi}
\alias{optimizer_yogi}
\title{Yogi}
\usage{
optimizer_yogi(
  learning_rate = 0.01,
  beta1 = 0.9,
  beta2 = 0.999,
  epsilon = 0.001,
  l1_regularization_strength = 0,
  l2_regularization_strength = 0,
  initial_accumulator_value = 1e-06,
  activation = "sign",
  name = "Yogi",
  clipnorm = NULL,
  clipvalue = NULL,
  decay = NULL,
  lr = NULL
)
}
\arguments{
\item{learning_rate}{A Tensor or a floating point value. The learning rate.}

\item{beta1}{A float value or a constant float tensor. The exponential decay rate for the 1st moment estimates.}

\item{beta2}{A float value or a constant float tensor. The exponential decay rate for the 2nd moment estimates.}

\item{epsilon}{A constant trading off adaptivity and noise.}

\item{l1_regularization_strength}{A float value, must be greater than or equal to zero.}

\item{l2_regularization_strength}{A float value, must be greater than or equal to zero.}

\item{initial_accumulator_value}{The starting value for accumulators. Only positive values are allowed.}

\item{activation}{Use hard sign or soft tanh to determin sign.}

\item{name}{Optional name for the operations created when applying gradients. Defaults to "Yogi".}

\item{clipnorm}{is clip gradients by norm.}

\item{clipvalue}{is clip gradients by value.}

\item{decay}{is included for backward compatibility to allow time inverse decay of learning rate.}

\item{lr}{is included for backward compatibility, recommended to use learning_rate instead.}
}
\value{
Optimizer for use with `keras::compile()`
}
\description{
Yogi
}
