% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{img_connected_components}
\alias{img_connected_components}
\title{Connected components}
\usage{
img_connected_components(images, name = NULL)
}
\arguments{
\item{images}{A 2D (H, W) or 3D (N, H, W) Tensor of image (integer,
floating point and boolean types are supported).}

\item{name}{The name of the op.}
}
\value{
Components with the same shape as `images`. entries that evaluate to
FALSE (e.g. 0/0.0f, FALSE) in `images` have value 0, and all other entries
map to a component id > 0.
}
\description{
Labels the connected components in a batch of images.
}
\details{
A component is a set of pixels in a single input image, which are
all adjacent and all have the same non-zero value. The components
using a squared connectivity of one (all equal entries are joined with
their neighbors above,below, left, and right). Components across all
images have consecutive ids 1 through n.
Components are labeled according to the first pixel of the
component appearing in row-major order (lexicographic order by
image_index_in_batch, row, col).
Zero entries all have an output id of 0.
This op is equivalent with `scipy.ndimage.measurements.label`
on a 2D array with the default structuring element
(which is the connectivity used here).
}
\section{Raises}{

TypeError: if `images` is not 2D or 3D.
}

