% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_negation.R
\name{handle_negation}
\alias{handle_negation}
\title{Handle Negation in Token List}
\usage{
handle_negation(tokens)
}
\arguments{
\item{tokens}{A character vector of tokens (individual words).}
}
\value{
A character vector of tokens with negations handled by combining "not" with the next word.
}
\description{
This function processes a character vector of tokens and handles negations by
combining the word "not" with the immediately following word (e.g., "not happy" becomes "not_happy").
This technique helps to better preserve sentiment polarity during text analysis.
}
\details{
The negation handling procedure follows these steps:
\itemize{
  \item Iterate through each token.
  \item If a token is "not" and followed by another token, merge them into a single token separated by an underscore (e.g., "not_happy").
  \item Skip the next token after merging to avoid duplication.
  \item Otherwise, keep the token unchanged.
}

This method is especially useful in sentiment analysis tasks where the presence of negations
can invert the sentiment polarity of words.
}
\examples{
handle_negation(c("i", "am", "not", "happy"))
# Returns: c("i", "am", "not_happy")

handle_negation(c("this", "is", "not", "good", "but", "not", "terrible"))
# Returns: c("this", "is", "not_good", "but", "not_terrible")

handle_negation(c("nothing", "to", "worry", "about"))
# Returns: c("nothing", "to", "worry", "about")

}
