% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgpd.R, R/pgpd.R, R/qgpd.R, R/rgpd.R
\name{dgpd}
\alias{dgpd}
\alias{pgpd}
\alias{qgpd}
\alias{rgpd}
\title{Density, cumulative density, quantiles and random number generation for the
generalized Pareto distribution}
\usage{
dgpd(x, sigma, xi, u = 0, log.d = FALSE)

pgpd(q, sigma, xi, u = 0, lower.tail = TRUE, log.p = FALSE)

qgpd(p, sigma, xi, u = 0, lower.tail = TRUE, log.p = FALSE)

rgpd(n, sigma, xi, u = 0)
}
\arguments{
\item{x, q, p}{Value, quantile or probability respectively.}

\item{sigma}{Scale parameter.}

\item{xi}{Shape parameter.}

\item{u}{Threshold}

\item{log.d, log.p}{Whether or not to work on the log scale.}

\item{lower.tail}{Whether to return the lower tail.}

\item{n}{Number of random numbers to simulate.}
}
\description{
Density, cumulative density, quantiles and random number generation for the
generalized Pareto distribution
}
\details{
Random number generation is done by transformation of a standard
exponential.
}
\examples{

  x <- rgpd(1000, sigma=1, xi=.5)
  hist(x)
  x <- rgpd(1000, sigma=exp(rnorm(1000, 1, .25)), xi=rnorm(1000, .5, .2))
  hist(x)
  plot(pgpd(x, sigma=1, xi=.5))

}
\author{
Janet E Heffernan, Paul Metcalfe, Harry Southworth
}
\keyword{models}
