% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/watcher.R
\name{watch}
\alias{watch}
\title{Watch a directory for changes (additions, deletions & modifications).}
\usage{
watch(path, callback, pattern = NULL, hash = TRUE)
}
\arguments{
\item{path}{character vector of paths to watch.  Omit trailing backslash.}

\item{callback}{function called every time a change occurs.  It should
have three parameters: added, deleted, modified, and should return
\code{TRUE} to keep watching, or \code{FALSE} to stop.}

\item{pattern}{file pattern passed to \code{\link[=dir]{dir()}}}

\item{hash}{hashes are more accurate at detecting changes, but are slower
for large files.  When \code{FALSE}, uses modification time stamps}
}
\description{
This is used to power the \code{\link[=auto_test]{auto_test()}} and
\code{\link[=auto_test_package]{auto_test_package()}} functions which are used to rerun tests
whenever source code changes.
}
\details{
Use Ctrl + break (windows), Esc (mac gui) or Ctrl + C (command line) to
stop the watcher.
}
\keyword{internal}
