% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_blanking_event_times.R
\name{duration_compare}
\alias{duration_compare}
\title{Compare the duration of Potential Blanking Periods}
\usage{
duration_compare(event_dur, var_groups = NULL, time_seq)
}
\arguments{
\item{event_dur}{the detection dataframe which has been condensed into
discrete events using each potential blanking period.}

\item{var_groups}{a single string or vector of strings of the columns which
should be used to group organisms. Common groupings are species and cohorts.}

\item{time_seq}{a vector of times on the same scale as the ping rate. The
largest value of the sequence should be greater that the longest duration
produced using blanking event, and the smallest should be shorter than the
smallest blanking period.}
}
\value{
A dataframe which contains the proportion of "survived" events
created by each potential blanking period for each time (t).
}
\description{
Takes a dataframe of detection data which has been condensed by potential
blanking periods generated by `blanking_event()` and compares the duration of
each event to a common sequence of increasing times. If the event is longer
than the duration it is flagged as "survived". The proportion of events which
"survive" for each potential blanking period at each time (t) is then
calculated.
}
\examples{
# Compare the durations of blanked detection events
duration_compare(event_dur = blanked_detects,
                 var_groups = "fish_type",
                 time_seq = c(1:10))
}
