% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_distance.R
\name{projected_pb_strike}
\alias{projected_pb_strike}
\title{Strike of the plate boundary projected on data point}
\usage{
projected_pb_strike(x, PoR, pb, tangential = FALSE, ...)
}
\arguments{
\item{x, pb}{\code{sf} objects of the data points and the plate boundary
geometries in the geographical coordinate system}

\item{PoR}{Pole of rotation. \code{"data.frame"} or object of class \code{"euler.pole"}
containing the geographical coordinates of the Euler pole}

\item{tangential}{Logical. Whether the plate boundary is a tangential
boundary (\code{TRUE}) or an inward and outward boundary (\code{FALSE}, the
default).}

\item{...}{optional arguments passed to \code{\link[smoothr:densify]{smoothr::densify()}}}
}
\value{
Numeric vector of the strike direction of the plate boundary
(in degree)
}
\description{
The fault's strike in the PoR CRS projected on the data point along the
predicted stress trajectories.
}
\details{
Useful to calculate the beta angle, i.e. the angle
between SHmax direction (in PoR CRS!) and the fault's strike (in PoR CRS).
The beta angle is the same in geographical and PoR coordinates.
}
\note{
The algorithm calculates the great circle bearing between line
vertices. Since transform plate boundaries represent small circle lines in
the PoR system, this great-circle azimuth is only a approximation of the
true (small-circle) azimuth.
}
\examples{
data("nuvel1")
na_pa <- subset(nuvel1, nuvel1$plate.rot == "na")

data("plates")
plate_boundary <- subset(plates, plates$pair == "na-pa")

data("san_andreas")
res <- projected_pb_strike(
  x = san_andreas, PoR = na_pa, pb = plate_boundary, tangential = TRUE
)
head(res)
head(san_andreas$azi - res) # beta angle
}
