% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Csurv.R
\name{Csurv}
\alias{Csurv}
\title{Conditional probability given the observed data estimate}
\usage{
Csurv(Y, M, censor, t, h=NULL, ktype="gaussian")
}
\arguments{
\item{Y}{The numeric vector of event-time or observed time.}

\item{M}{The numeric vector of marker value.}

\item{censor}{The censoring indicator, \code{1} if event, \code{0} otherwise.}

\item{t}{A scalar time point used to calculate the the ROC curve}

\item{h}{A scalar bandwidth value for kernel weights estimation. The default is the value obtained using the method of Sheather and Jones (1991).}

\item{ktype}{A character string specifying the desired kernel needed for Beran weight calculation. The possible options are "\code{normal}", "\code{epanechnikov}", "\code{tricube}", "\code{boxcar}", "\code{triangular}", or "\code{quartic}". The defaults is "\code{gaussian}" kernel density.}
}
\value{
Return a list containing:

\item{positive }{estimate of  \code{P(T<t|Y,censor,M)}.}

\item{negative }{estimate of  \code{P(T>t|Y,censor,M)}.}
}
\description{
{This is the base function of the package that uses the Beran nonparametric conditional survival function
estimator for right-censored data to estimate the conditional probability of the
event \code{T<t} (i.e., the event occurring before time t) or \code{T>t} (i.e., the event occurring
after time t), given the observed data.
}
}
\examples{
library(tdPRC);
data(mayo);

data <- mayo[ ,c( "time","censor","mayoscore5" )] ;
t <- 365*6;

est <- Csurv(Y=data$time, M=data$mayoscore5, censor=data$censor, t=t, ktype="gaussian")

summary(est$positive)

}
\references{
Beyene, K.M., Chen, D.G., and Kifle, Y.G. (2024). A novel nonparametric time‐dependent precision-recall curve estimator for right‐censored survival data. \emph{Biometrical Journal}, 66(3), 2300135.

Beyene, K.M. and El Ghouch A. (2020). Smoothed time-dependent receiver operating characteristic curve for right censored survival data. \emph{Statistics in Medicine}, 39: 3373-3396.
}
