% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcempirical_top.R
\name{calcempirical_top}
\alias{calcempirical_top}
\title{Empirically locate top and top concentration}
\usage{
calcempirical_top(conc, ps, fname, precision = 100)
}
\arguments{
\item{conc}{Vector of concentrations}

\item{ps}{Vector of parameters, must be in order: a, tp, b, ga, p, la, q, er}

\item{fname}{Model function name (equal to model name except hill which
uses "hillfn")}

\item{precision}{Number of points sampled on the base-10 logarithmic scaled experimental concentration range. (Defaults to 100.)}
}
\value{
A named list of the top and top concentration. The elements of the list are:
 \itemize{
   \item top - empirical top
   \item x_top - concentration at which empirical top occurs
 }
}
\description{
Locate the top and the concentration at which top occurs empirically by sampling points within the experimental concentration range.
}
\examples{
conc = c(.03,.1,.3,1,3,10,30,100)
ps = c(1,2,1,2,2)
fname = "gnls"
calcempirical_top(conc, ps, fname)
}
