% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{olc}
\alias{olc}
\title{Simulate open-loop control}
\usage{
olc(
  pkmod_prior,
  pkmod_true,
  target_vals,
  target_tms,
  obs_tms,
  type = c("effect", "plasma"),
  custom_alg = NULL,
  resp_bounds = NULL,
  seed = NULL
)
}
\arguments{
\item{pkmod_prior}{`pkmod` object describing a PK/PK-PD model that is used to calculate
TCI infusion rates and is updated as data are simulated and incorporated. Must have an
associated Omega matrix.}

\item{pkmod_true}{`pkmod` object describing the patient's "true" response. This model
will be used to simulate observations.}

\item{target_vals}{A vector of numeric values indicating PK or PD targets for TCI algorithm.}

\item{target_tms}{A vector of numeric values indicating times at which the TCI algorithm should
begin targeting each value.}

\item{obs_tms}{Times at which data values should be simulated from `pkmod_true`.}

\item{type}{Type of TCI algorithm to be used. Options are "plasma" and "effect".
Defaults to "effect". Will be overwritten if `custom_alg` is non-null.}

\item{custom_alg}{Custom TCI algorithm to overwrite default plasma- or effect-site targeting.}

\item{resp_bounds}{Optional vector of two values indicating minimum and maximum values possible for the response.}

\item{seed}{An integer used to initialize the random number generator.}
}
\description{
Simulate open-loop control with target-controlled infusion for a `pkmod` object.
Infusion rates are calculated using `pkmod_prior` to reach `target_vals` at
`target_tms`. Data values are simulated using `pkmod_true` at `obs_tms`.
`pkmod_prior` and `pkmod_true` do not need to have the same structure.
}
\examples{
pkmod_prior <- pkmod(pars_pk = c(cl = 10, q2 = 2, q3 =20, v = 15, v2 = 30, v3 = 50, ke0 = 1.2))
pkmod_true  <- pkmod(pars_pk = c(cl = 16, q2 = 4, q3 =10, v = 20, v2 = 20, v3 = 80, ke0 = 0.8),
sigma_add = 0.1, log_response = TRUE)
target_vals <- c(2,3,4,3,3)
target_tms <- c(0,5,10,36,60)
obs_tms <- c(1,2,4,8,12,16,24,36,48)
sim <- olc(pkmod_prior, pkmod_true, target_vals, target_tms, obs_tms)
len <- 500
tms <- seq(0,60,length.out = len)
df <- data.frame(time = rep(tms,2),
                 value = c(predict(pkmod_true, sim$inf,tms)[,1],
                 predict(pkmod_prior, sim$inf,tms)[,1]),
                 type = c(rep("true",len),rep("prior",len)))
library(ggplot2)
ggplot(df, aes(x = time, y = value, color = type)) +
  geom_step(data = data.frame(time = target_tms, value = target_vals),
  aes(x = time, y = value), inherit.aes = FALSE) +
  geom_line() +
  geom_point(data = sim$obs, aes(x = time, y = obs), inherit.aes = FALSE)
}
