% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{tcfu}
\alias{tcfu}
\title{The TCFU test}
\usage{
tcfu(x1, x2, effectSize = 0, alternative = "greater", alpha = 0.05, order = 2)
}
\arguments{
\item{x1}{the first sample.}

\item{x2}{the second sample.}

\item{effectSize}{the effect size of the test. The default value is 0.}

\item{alternative}{the alternative hypothesis: "greater" for upper-tailed, "less" for lower-tailed, and "two.sided" for two-sided alternative.}

\item{alpha}{the significance level. The default value is 0.05.}

\item{order}{the order of the Cornish-Fisher expansion.}
}
\value{
test statistic, critical value, p-value, reject decision at the given significance level.
}
\description{
This test is suitable for testing the equality of
two-sample means for the populations having unequal variances.
When the populations are not normally distributed, this test
can provide better type I error control and more accurate power than a large-sample t-test using normal
approximation. The critical values of the test are computed based on the
Cornish-Fisher expansion of the Welch's t-statistic. The order of the
Cornish-Fisher expansion is allowed to be 0, 1, or 2. More details
please refer to Zhang and Wang (2020).
}
\examples{
x1 <- rnorm(20, 1, 3)
x2 <- rnorm(21, 2, 3)
tcfu(x1, x2, alternative = 'two.sided')
}
\references{
Zhang, H. and Wang, H. (2020). Transformation tests and their asymptotic power in two-sample comparisons. Manuscript in review.
}
