% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcftt.R
\docType{package}
\name{tcftt}
\alias{tcftt}
\title{tcftt: Two-Sample Tests for Skewed Data}
\description{
The classical two-sample t-test works well for the normally distributed data or data with large sample size.
The tcfu() and tt() tests implemented in this package provide better type I error control with more accurate power
when testing the equality of two-sample means for skewed populations having
unequal variances. The approximation is especially useful when the sample sizes are moderate. The tcfu()
uses the Cornish-Fisher expansion to achieve a better approximation to the
true percentiles. The tt() provides transformations of the Welch's t-statistic so that the
sampling distribution become more symmetric. For more technical details, please
refer to Zhang (2019) <http://hdl.handle.net/2097/40235>.
}
\section{tcftt functions}{

The function `tcfu()` implements the Cornish-Fisher based two-sample test (TCFU)
and `tt()` implements the transformation based two-sample test (TT).
The function `t_edgeworth()` provides the Edgeworth expansion for
cumulative distribution function for the Welch's t-statistic, and `t_cornish_fisher()`
provides the Cornish-Fisher expansion for the percentiles.
The functions `adjust_power()` and `pauc()` provide power adjustment
for simulation studies so that the actual size of the tests are within the significance level.
}

