% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.ci.R
\name{boot.ci}
\alias{boot.ci}
\title{Estimate the confidence interval of SACE using bootstrap.}
\usage{
boot.ci(object, nboot = 1000, seed = 100:(100 + nboot - 1), alpha = 0.05,
  max.step = 1000, singular.ok = FALSE, print.progress = TRUE)
}
\arguments{
\item{object}{an object of class \code{sace}.}

\item{nboot}{a positive integer. The number of bootstrap samples desired.}

\item{seed}{an integer vector with length \code{nboot}. Seed to generate samples.}

\item{alpha}{confidence level.}

\item{max.step}{see documentation of \link[tbd]{sace}.}

\item{singular.ok}{see documentation of \link[tbd]{sace}.}

\item{print.progress}{logical. Need progress be printed?}
}
\value{
a list with 4 elements:
\item{nskip}{number of failures during bootstrap.}
\item{sace.boot.record}{a vector with length \code{nboot}-\code{skip}. SACE estimates of all bootstrap samples.}
\item{boot.sd}{scaler. Standard deviation of SACE estimates of all bootstrap samples.}
\item{ci}{a vector with length 2. Estimated confidence interval.}
}
\description{
Give quantiles of bootstrap samples SACE.
}
\author{
Zhixuan Shao <shaozhixuansh@pku.edu.cn>
}

