% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_higher_taxo.R
\name{list_higher_taxo}
\alias{list_higher_taxo}
\title{Get higher taxonomy data for list of names}
\usage{
list_higher_taxo(
  indf,
  canonical,
  genus = FALSE,
  verbose = FALSE,
  progress = TRUE
)
}
\arguments{
\item{indf}{input data frame containing taxonomic list}

\item{canonical}{field name containing scientific names}

\item{genus}{If TRUE, use only genus level data to get taxonomy}

\item{verbose}{If TRUE, displays each name string for which the higher
taxonomy is sought}

\item{progress}{If TRUE prints progress bar and messages on the console.}
}
\value{
data frame with added / updated columns \describe{ \item{"Kingdom"}{Kingdom
 of the Scientific name} \item{"Phylum"}{Phylum of the Scientific name}
 \item{"Order_"}{Order of the Scientific name} \item{"Family"}{Family of the
 Scientific name} \item{"Genus"}{Genus of the Scientific name} } and also
 saves a local copy of taxonomy downloaded for future use in 'taxo.db' sqlite
 file
}
\description{
Retrieve higher taxonomy information (like Family and Order) for each record
from the "Encyclopedia of Life" web API.
}
\details{
This function scans and retrieves the taxonomic hierarchy for each scientific
name (or just genus name) in the data set. When new data are retrieved, they
are stored in a local sqlite database, taxo.db, for faster further access.
}
\examples{
\dontrun{
mylist <- data.frame("canonical" = c("Abrothrix longipilis",
                                    "Mus longipilis",
                                    "Abrothrix jelskii",
                                    "Cardinalis cardinalis",
                                    "Danaus plexippus"),
                    stringsAsFactors = FALSE)

my_taxo_list <- list_higher_taxo(mylist,"canonical")
}
}
\seealso{
Other Name functions: 
\code{\link{build_gen_syn}()},
\code{\link{cast_canonical}()},
\code{\link{cast_scientificname}()},
\code{\link{check_scientific}()},
\code{\link{expand_name}()},
\code{\link{get_accepted_names}()},
\code{\link{guess_taxo_rank}()},
\code{\link{melt_canonical}()},
\code{\link{melt_scientificname}()},
\code{\link{resolve_names}()},
\code{\link{taxo_fuzzy_match}()}
}
\concept{Name functions}
