% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ap_taxid2name.R
\name{taxid2name}
\alias{taxid2name}
\title{Convert taxon IDs to scientific names}
\usage{
taxid2name(x, db = "ncbi", verbose = TRUE, warn = TRUE, ...)
}
\arguments{
\item{x}{(character) Vector of taxon keys for the given database}

\item{db}{(character) The database to search, one of ncbi, itis, gbif,
col, wfo, or tpl}

\item{verbose}{(logical) Print verbose messages}

\item{warn}{(logical) If \code{TRUE}, raise a warning if any taxon IDs can not
be found}

\item{...}{Additional arguments passed to database specific classification
functions}
}
\value{
character vector of scientific names
}
\description{
Convert taxon IDs to scientific names
}
\examples{
\dontrun{
taxid2name(c(3702, 9606))
taxid2name(c(154395, 154357, 23041, 154396), db = "itis")
taxid2name(c('wfo-0000541830', 'wfo-0000291463'), db = "wfo")
taxid2name("wfo-7000000057", db = "wfo")
taxid2name(2877951, db = "gbif")
taxid2name(c(2877951, 5386), db = "gbif")
taxid2name(c("C66T4", "C7ZVH", "TP"), db = "col")
taxid2name(c("kew-2614538", "kew-2895433", "kew-2615007"), db = "tpl")
}
}
