% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactor.R
\name{refactor}
\alias{refactor}
\title{Refactor Cluster Levels}
\usage{
refactor(object, ..., inheret_parameters = TRUE)
}
\arguments{
\item{object}{A \code{medic} object.}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Name-value pairs.
\code{...} is passed to \code{\link[dplyr:mutate]{dplyr::mutate}}, and therefor inherits its behavior:

The name gives the name of the new clustering in the output. The value can
be:
\itemize{
\item A vector of length 1, which will be recycled to the correct length.
\item A function of another clustering.
}

When a recording uses the name of an existing clustering, this new
clustering will overwrite the existing one.}

\item{inheret_parameters}{A logical. If \code{TRUE} a new clustering overwriting
an existing clustering inherits the \code{parameters} of the old.}
}
\value{
A \code{medic} object with relevant clusterings refactored.
}
\description{
Refactor the levels of the chosen clusters.
}
\examples{

clust <- medic(complications, id = id, atc = atc, k = 3:4)

# Refactor one clustering
refactor(
  clust,
  `cluster_1_k=4` = dplyr::recode(`cluster_1_k=4`, IV = "III")
)

# Refactor all clusterings
refactor(
  clust,
  dplyr::across(
    dplyr::everything(),
    ~dplyr::recode(., IV = "III")
  )
)

}
