% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust-probability-threshold.R
\name{adjust_probability_threshold}
\alias{adjust_probability_threshold}
\title{Change the event threshold}
\usage{
adjust_probability_threshold(x, threshold = 0.5)
}
\arguments{
\item{x}{A \code{\link[=tailor]{tailor()}}.}

\item{threshold}{A numeric value (between zero and one) or \code{\link[hardhat:tune]{hardhat::tune()}}.}
}
\value{
An updated \code{\link[=tailor]{tailor()}} containing the new operation.
}
\description{
Many machine learning systems determine hard class predictions by
first predicting the probability of an event and then predicting that
an event will occur if its respective probability is above 0.5. This
adjustment allows practitioners to determine hard class predictions using
a threshold other than 0.5. By setting appropriate thresholds, one can
balance the trade-off between different types of errors (such as
false positives and false negatives) to optimize the model's performance
for specific use cases.
}
\section{Data Usage}{

This adjustment doesn't require estimation and, as such, the same data that's
used to train it with \code{fit()} can be predicted on with \code{predict()}; fitting
this adjustment just collects metadata on the supplied column names and does
not risk data leakage.
}

\examples{
\dontshow{if (rlang::is_installed(c("probably", "modeldata"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(modeldata)

# `predicted` gives hard class predictions based on probability threshold .5
head(two_class_example)

# use a threshold of .1 instead:
tlr <-
  tailor() |>
  adjust_probability_threshold(.1)

# fit by supplying column names.
tlr_fit <- fit(
  tlr,
  two_class_example,
  outcome = c(truth),
  estimate = c(predicted),
  probabilities = c(Class1, Class2)
)

# adjust hard class predictions
predict(tlr_fit, two_class_example) |> head()
\dontshow{\}) # examplesIf}
}
