% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantiles.R
\name{quantiles}
\alias{quantiles}
\title{Efficient quantiles}
\usage{
quantiles(df, ..., probs = seq(0, 1, 0.1), na.rm = FALSE)
}
\arguments{
\item{df}{A data.table, tibble, or data.frame.}

\item{...}{A column or set of columns (without quotation marks).}

\item{probs}{numeric vector of probabilities with values in [0,1].}

\item{na.rm}{logical; if true, any NA and NaN's are removed from x before the quantiles are computed.}
}
\value{
Quantile values.
}
\description{
Produces quantiles of the variables.
\code{quantiles} shows quantile values.
Efficient with big data: if you give it a \code{data.table},
		\code{quantiles} uses \code{data.table} syntax.
}
\examples{
# data.table
library(data.table)
library(magrittr)
a <- data.table(varname = sample.int(20, size = 1000000, replace = TRUE))
a \%>\% quantiles(varname)

# data.table: look at top 10\% in more detail
a \%>\% quantiles(varname, probs = seq(0.9, 1, 0.01))

# tibble
library(dplyr)
b <- tibble(varname = sample.int(20, size = 1000000, replace = TRUE))
b \%>\% quantiles(varname, na.rm = TRUE)

}
