% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabmedians_svy.R
\name{tabmedians.svy}
\alias{tabmedians.svy}
\title{Create Table Comparing Group Medians (for Complex Survey Data)}
\usage{
tabmedians.svy(
  formula,
  design,
  columns = c("xgroups", "p"),
  parenth = "iqr",
  sep.char = ", ",
  xlevels = NULL,
  yname = NULL,
  text.label = NULL,
  decimals = NULL,
  svyranktest.list = NULL,
  formatp.list = NULL,
  n.headings = FALSE,
  N.headings = FALSE,
  kable = TRUE
)
}
\arguments{
\item{formula}{Formula, e.g. \code{BMI ~ Sex}.}

\item{design}{Survey design object from \code{\link[survey]{svydesign}}.}

\item{columns}{Character vector specifying what columns to include. Choices
for each element are \code{"n"} for total sample size, \code{"overall"} for
overall median, \code{"xgroups"} for \code{x} group medians, \code{"diff"}
for difference in \code{x} group medians (only available for binary
\code{x}), and \code{"p"} for p-value.}

\item{parenth}{Character string specifying what values are shown in
parentheses after the medians in each cell. Choices are \code{"none"},
\code{"iqr"}, \code{"q1q3"} for first and third quartiles, \code{"range"},
\code{"minmax"}, and \code{"ci"} for 95\% confidence interval for the median.}

\item{sep.char}{Character string with separator to place between lower and
upper bound of confidence intervals. Typically \code{"-"} or \code{", "}.}

\item{xlevels}{Character vector with labels for the levels of \code{x}, used
in column headings.}

\item{yname}{Character string with a label for the \code{y} variable.}

\item{text.label}{Character string with text to put after the \code{y}
variable name, identifying what cell values and parentheses represent.}

\item{decimals}{Numeric value specifying number of decimal places for numbers
other than p-values.}

\item{svyranktest.list}{List of arguments to pass to
\code{\link[survey]{svyranktest}}.}

\item{formatp.list}{List of arguments to pass to \code{\link[tab]{formatp}}.}

\item{n.headings}{Logical value for whether to display group sample sizes in
parentheses in column headings.}

\item{N.headings}{Logical value for whether to display weighted sample sizes
in parentheses in column headings.}

\item{kable}{Logical value for whether to return a
\code{\link[knitr]{kable}}.}
}
\value{
\code{\link[knitr]{kable}} or character matrix.
}
\description{
Creates a table comparing the median of \code{y} across levels of \code{x}.
}
\details{
Basically \code{\link{tabmedians}} for complex survey data. Relies heavily on
the \pkg{survey} package.
}
\examples{
# Create survey design object
library("survey")
design <- svydesign(
  data = tabsvydata,
  ids = ~sdmvpsu,
  strata = ~sdmvstra,
  weights = ~wtmec2yr,
  nest = TRUE
)

# Compare median BMI by sex
(medtable1 <- tabmedians.svy(BMI ~ Sex, design = design))


}
