% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kostka.R
\name{KostkaNumbersWithGivenMu}
\alias{KostkaNumbersWithGivenMu}
\title{Kostka numbers with given \eqn{\mu}}
\usage{
KostkaNumbersWithGivenMu(mu, output = "vector")
}
\arguments{
\item{mu}{integer partition}

\item{output}{the format of the output, either \code{"vector"} or 
\code{"list"}}
}
\value{
If \code{output="vector"}, this function returns a named vector. 
  This vector is made of the positive Kostka numbers 
  \eqn{K(\lambda,\mu)} and its names encode the partitions \eqn{\lambda}.
  If \code{output="list"}, this function returns a list of lists. 
  Each of these lists has two 
  elements. The first one is named \code{lambda} and is an integer 
  partition, and the second one is named \code{value} and is a positive 
  integer, the Kostka number \eqn{K(\lambda,\mu)}. It is faster to 
  compute the Kostka numbers with this function than computing the 
  individual Kostka numbers with the function \code{\link{KostkaNumber}}.
}
\description{
Lists all positive Kostka numbers \eqn{K(\lambda,\mu)} with 
  a given partition \eqn{\mu}.
}
\examples{
KostkaNumbersWithGivenMu(c(2, 1, 1))
}
\seealso{
\code{\link{KostkaNumber}}, \code{\link{KostkaNumbers}}, 
  \code{\link{KostkaNumbersWithGivenLambda}}.
}
